/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.design.visio.model.mapping;

import filenet.vw.toolkit.design.visio.model.Shape;
import filenet.vw.toolkit.design.visio.model.mapping.VWBoundingRectangle;
import filenet.vw.toolkit.design.visio.model.mapping.VWMappingHelper;
import filenet.vw.toolkit.design.visio.resources.VWResource;
import filenet.vw.toolkit.utils.VWStringUtils;
import java.util.Vector;

abstract class VWContainerItem {
    protected static final int INDEX_MY_SHAPES = 0;
    protected static final int INDEX_REMAINING_SHAPES = 1;
    protected static final int MODE_TAKE_NO_SHAPES = -1;
    protected static final int MODE_TAKE_ALL_SHAPES = 0;
    protected static final int MODE_TAKE_CONTAINED_SHAPES = 1;
    protected Shape m_myShape = null;
    protected VWBoundingRectangle m_boundingRectangle = null;
    protected int m_nMode = -1;

    protected VWContainerItem(Shape myShape) {
        this.setShape(myShape);
    }

    protected void resetMode() {
        this.m_nMode = -1;
    }

    protected void setShape(Shape myShape) {
        this.m_myShape = myShape;
        this.m_boundingRectangle = new VWBoundingRectangle(myShape);
        this.m_nMode = this.m_myShape != null ? 1 : 0;
    }

    protected Vector[] findContainedShapes(Vector shapes) {
        switch (this.m_nMode) {
            case 1: {
                if (this.m_myShape != null && shapes != null && shapes.size() > 0) {
                    Vector<Shape> myShapeList = new Vector<Shape>();
                    for (int nIndex = shapes.size() - 1; nIndex >= 0; --nIndex) {
                        VWBoundingRectangle tmpBoundingRectangle;
                        Shape tempShape = (Shape)shapes.elementAt(nIndex);
                        if (tempShape.equals(this.m_myShape) || !this.m_boundingRectangle.contains(tempShape) || VWStringUtils.compare(tempShape.getDesignerObjectName(), VWResource.s_submap) == 0 && (tmpBoundingRectangle = new VWBoundingRectangle(tempShape)).contains(this.m_boundingRectangle)) continue;
                        myShapeList.addElement(tempShape);
                        shapes.removeElementAt(nIndex);
                    }
                    return new Vector[]{myShapeList, shapes};
                }
            }
            case 0: {
                return new Vector[]{shapes, new Vector()};
            }
        }
        return new Vector[]{new Vector(), shapes};
    }

    protected abstract Vector setSteps(Vector var1, VWMappingHelper var2);

    protected abstract Vector setStartSteps(Vector var1);

    protected abstract Vector setRoutes(Vector var1);

    protected abstract Vector setTextAnnotations(Vector var1);

    protected abstract Vector setAssociations(Vector var1);

    protected abstract void convertShapes(VWMappingHelper var1, int var2);
}

